﻿/* http://keith-wood.name/calendars.html
 Hungarian localisation for Gregorian/Julian calendars for jQuery.
 Written by Istvan Karaszi (jquerycalendar@spam.raszi.hu). */
        (function ($) {
            $.calendars.calendars.gregorian.prototype.regionalOptions['hu'] = {
                name: 'Gregorian',
                epochs: ['BCE', 'CE'],
                monthNames: ['Január', 'Február', 'Március', 'Április', 'Május', 'Június',
                    'Július', 'Augusztus', 'Szeptember', 'Október', 'November', 'December'],
                monthNamesShort: ['Jan', 'Feb', 'Már', 'Ápr', 'Máj', 'Jún',
                    'Júl', 'Aug', 'Szep', 'Okt', 'Nov', 'Dec'],
                dayNames: ['Vasárnap', 'Hétfö', 'Kedd', 'Szerda', 'Csütörtök', 'Péntek', 'Szombat'],
                dayNamesShort: ['Vas', 'Hét', 'Ked', 'Sze', 'Csü', 'Pén', 'Szo'],
                dayNamesMin: ['V', 'H', 'K', 'Sze', 'Cs', 'P', 'Szo'],
                dateFormat: 'yyyy-mm-dd',
                firstDay: 1,
                isRTL: false
            };
            if ($.calendars.calendars.julian) {
                $.calendars.calendars.julian.prototype.regionalOptions['hu'] =
                        $.calendars.calendars.gregorian.prototype.regionalOptions['hu'];
            }
        })(jQuery);
