<?php

/**
 * Class that operate on table 'usergroup'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class UsergroupMySqlDAO implements UsergroupDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return UsergroupMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM usergroup WHERE usergroupid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM usergroup';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM usergroup ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param usergroup primary key
     */
    public function delete($usergroupid) {
        $sql = 'DELETE FROM usergroup WHERE usergroupid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($usergroupid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param UsergroupMySql usergroup
     */
    public function insert($usergroup) {
        $sql = 'INSERT INTO usergroup (usergroupname, usergroupdescription, currentdate, conditions, startpage, level,savedailydate ,hidemenu,hidecat,clientnegative,suplliernegative,storenegative,directDiscount,percentageDiscount,priceupdate) VALUES (?, ?, ?, ?, ?, ?,? ,?,?,?,?,? ,? ,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($usergroup->usergroupname);
        $sqlQuery->setString2($usergroup->usergroupdescription);
        $sqlQuery->set($usergroup->currentdate);
        $sqlQuery->setNumber($usergroup->conditions);
        $sqlQuery->set($usergroup->startpage);
        $sqlQuery->setNumber($usergroup->level);
        $sqlQuery->set($usergroup->savedailydate);
        $sqlQuery->setNumber($usergroup->hidemenu);
        $sqlQuery->setNumber($usergroup->hidecat);
        $sqlQuery->setNumber($usergroup->clientnegative);
        $sqlQuery->setNumber($usergroup->suplliernegative);
        $sqlQuery->setNumber($usergroup->storenegative);
        $sqlQuery->set($usergroup->directDiscount);
        $sqlQuery->set($usergroup->percentageDiscount);
        $sqlQuery->set($usergroup->priceupdate);
        $id = $this->executeInsert($sqlQuery);
        $usergroup->usergroupid = $id;


        return $id;
    }

    /**
     * Update record in table
     *
     * @param UsergroupMySql usergroup
     */
    public function update($usergroup) {
        $sql = 'UPDATE usergroup SET usergroupname = ?, usergroupdescription = ?, currentdate = ?, conditions = ?, startpage = ?, level = ? ,savedailydate=? ,
		hidemenu = ?, hidecat = ?,clientnegative= ?,suplliernegative=?,storenegative=?, directDiscount = ?, percentageDiscount = ?, priceupdate = ?

		WHERE usergroupid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($usergroup->usergroupname);
        $sqlQuery->setString2($usergroup->usergroupdescription);
        $sqlQuery->set($usergroup->currentdate);
        $sqlQuery->setNumber($usergroup->conditions);
        $sqlQuery->set($usergroup->startpage);
        $sqlQuery->setNumber($usergroup->level);
        $sqlQuery->setNumber($usergroup->savedailydate);

        $sqlQuery->setNumber($usergroup->hidemenu);
        $sqlQuery->setNumber($usergroup->hidecat);

        $sqlQuery->setNumber($usergroup->clientnegative);
        $sqlQuery->setNumber($usergroup->suplliernegative);
        $sqlQuery->setNumber($usergroup->storenegative);

        $sqlQuery->set($usergroup->directDiscount);
        $sqlQuery->set($usergroup->percentageDiscount);
        $sqlQuery->setNumber($usergroup->priceupdate);

        $sqlQuery->setNumber($usergroup->usergroupid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM usergroup';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByUsergroupname($value) {
        $sql = 'SELECT * FROM usergroup WHERE usergroupname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUsergroupdescription($value) {
        $sql = 'SELECT * FROM usergroup WHERE usergroupdescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrentdate($value) {
        $sql = 'SELECT * FROM usergroup WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM usergroup WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStartpage($value) {
        $sql = 'SELECT * FROM usergroup WHERE startpage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLevel($value) {
        $sql = 'SELECT * FROM usergroup WHERE level = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByUsergroupname($value) {
        $sql = 'DELETE FROM usergroup WHERE usergroupname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUsergroupdescription($value) {
        $sql = 'DELETE FROM usergroup WHERE usergroupdescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrentdate($value) {
        $sql = 'DELETE FROM usergroup WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM usergroup WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStartpage($value) {
        $sql = 'DELETE FROM usergroup WHERE startpage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLevel($value) {
        $sql = 'DELETE FROM usergroup WHERE level = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return UsergroupMySql
     */
    protected function readRow($row) {
        $usergroup = new Usergroup();

        $usergroup->usergroupid = $row['usergroupid'];
        $usergroup->usergroupname = $row['usergroupname'];
        $usergroup->usergroupdescription = $row['usergroupdescription'];
        $usergroup->currentdate = $row['currentdate'];
        $usergroup->conditions = $row['conditions'];
        $usergroup->startpage = $row['startpage'];
        $usergroup->level = $row['level'];
        $usergroup->savedailydate = $row['savedailydate'];

        $usergroup->hidemenu = $row['hidemenu'];
        $usergroup->hidecat = $row['hidecat'];

        $usergroup->clientnegative = $row['clientnegative'];
        $usergroup->suplliernegative = $row['suplliernegative'];
        $usergroup->storenegative = $row['storenegative'];


        $usergroup->directDiscount = $row['directDiscount'];
        $usergroup->percentageDiscount = $row['percentageDiscount'];
        $usergroup->priceupdate = $row['priceupdate'];



        return $usergroup;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return UsergroupMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>