<?php

/**
 * Class that operate on table 'serialsarchive'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-11-20 09:04
 */
class SerialsarchiveMySqlDAO implements SerialsarchiveDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SerialsarchiveMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM serialsarchive WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM serialsarchive';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM serialsarchive ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param serialsarchive primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM serialsarchive WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SerialsarchiveMySql serialsarchive
     */
    public function insert($serialsarchive) {
        $sql = 'INSERT INTO serialsarchive (deviceid, userno, syncusers,synctime, clientname, dateto, userid, sysdate, conditions) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setString2($serialsarchive->deviceid);
        $sqlQuery->setNumber($serialsarchive->userno);
        $sqlQuery->setNumber($serialsarchive->syncusers);
        $sqlQuery->setNumber($serialsarchive->synctime);
        $sqlQuery->setString2($serialsarchive->clientname);
        $sqlQuery->set($serialsarchive->dateto);
        $sqlQuery->setNumber($serialsarchive->userid);
        $sqlQuery->set($serialsarchive->sysdate);
        $sqlQuery->setNumber($serialsarchive->conditions);

        $id = $this->executeInsert($sqlQuery);
        $serialsarchive->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SerialsarchiveMySql serialsarchive
     */
    public function update($serialsarchive) {
        $sql = 'UPDATE serialsarchive SET deviceid = ?, userno = ?, syncusers = ?, synctime = ?, clientname = ?, dateto = ?, userid = ?, sysdate = ?, conditions = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setString2($serialsarchive->deviceid);
        $sqlQuery->setNumber($serialsarchive->userno);
        $sqlQuery->setNumber($serialsarchive->syncusers);
        $sqlQuery->setNumber($serialsarchive->synctime);
        $sqlQuery->setString2($serialsarchive->clientname);
        $sqlQuery->set($serialsarchive->dateto);
        $sqlQuery->setNumber($serialsarchive->userid);
        $sqlQuery->set($serialsarchive->sysdate);
        $sqlQuery->setNumber($serialsarchive->conditions);

        $sqlQuery->setNumber($serialsarchive->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM serialsarchive';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByDeviceid($value) {
        $sql = 'SELECT * FROM serialsarchive WHERE deviceid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserno($value) {
        $sql = 'SELECT * FROM serialsarchive WHERE userno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySyncusers($value) {
        $sql = 'SELECT * FROM serialsarchive WHERE syncusers = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientname($value) {
        $sql = 'SELECT * FROM serialsarchive WHERE clientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDateto($value) {
        $sql = 'SELECT * FROM serialsarchive WHERE dateto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM serialsarchive WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM serialsarchive WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM serialsarchive WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByDeviceid($value) {
        $sql = 'DELETE FROM serialsarchive WHERE deviceid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserno($value) {
        $sql = 'DELETE FROM serialsarchive WHERE userno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySyncusers($value) {
        $sql = 'DELETE FROM serialsarchive WHERE syncusers = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientname($value) {
        $sql = 'DELETE FROM serialsarchive WHERE clientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDateto($value) {
        $sql = 'DELETE FROM serialsarchive WHERE dateto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM serialsarchive WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM serialsarchive WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM serialsarchive WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SerialsarchiveMySql
     */
    protected function readRow($row) {
        $serialsarchive = new Serialsarchive();

        $serialsarchive->id = $row['id'];
        $serialsarchive->deviceid = $row['deviceid'];
        $serialsarchive->userno = $row['userno'];
        $serialsarchive->syncusers = $row['syncusers'];
        $serialsarchive->synctime = $row['synctime'];
        $serialsarchive->clientname = $row['clientname'];
        $serialsarchive->dateto = $row['dateto'];
        $serialsarchive->userid = $row['userid'];
        $serialsarchive->sysdate = $row['sysdate'];
        $serialsarchive->conditions = $row['conditions'];

        //
        $serialsarchive->userName = $row['userName'];

        return $serialsarchive;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SerialsarchiveMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>