<?php

/**
 * Class that operate on table 'programsettings'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ProgramsettingsMySqlDAO implements ProgramsettingsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProgramsettingsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM programsettings WHERE programsettingsid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM programsettings';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM programsettings ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param programsetting primary key
     */
    public function delete($programsettingsid) {
        $sql = 'DELETE FROM programsettings WHERE programsettingsid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($programsettingsid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProgramsettingsMySql programsetting
     */
    public function insert($programsetting) {
        $sql = 'INSERT INTO programsettings (companyname, address, specializtion, phone, faxnumber, email, website, logo, roundnumbers, saveprinting, deptprinting, printingpapersize, userid, showPreviousPrice,parcode,priceing,lastprice,searchvalue,updateproductprice,`partition`,taxcard, commercialregistration,costcenter,clinic,workshop,transport,manufacturing,masterCopy , dailyentrydate , updatefiledate,workerbetweenstores,workshoptimeout,drivertimeout,currancy,serial) VALUES (? , ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?,?,? ,? ,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($programsetting->companyname);
        $sqlQuery->set($programsetting->address);
        $sqlQuery->set($programsetting->specializtion);
        $sqlQuery->set($programsetting->phone);
        $sqlQuery->set($programsetting->faxnumber);
        $sqlQuery->set($programsetting->email);
        $sqlQuery->set($programsetting->website);
        $sqlQuery->set($programsetting->logo);
        $sqlQuery->setNumber($programsetting->roundnumbers);
        $sqlQuery->setNumber($programsetting->saveprinting);
        $sqlQuery->setNumber($programsetting->deptprinting);
        $sqlQuery->setNumber($programsetting->printingpapersize);
        $sqlQuery->setNumber($programsetting->userid);
        $sqlQuery->setNumber($programsetting->showPreviousPrice);
        $sqlQuery->setNumber($programsetting->parcode);
        $sqlQuery->setNumber($programsetting->priceing);
        $sqlQuery->setNumber($programsetting->lastprice);
        $sqlQuery->setNumber($programsetting->searchvalue);
        $sqlQuery->setNumber($programsetting->updateproductprice);
        $sqlQuery->set($programsetting->partition);
        $sqlQuery->set($programsetting->taxcard);
        $sqlQuery->set($programsetting->commercialregistration);
        $sqlQuery->setNumber($programsetting->costcenter);
        $sqlQuery->setNumber($programsetting->clinic);
        $sqlQuery->setNumber($programsetting->workshop);
        $sqlQuery->setNumber($programsetting->transport);
        $sqlQuery->setNumber($programsetting->manufacturing);
        $sqlQuery->setNumber($programsetting->masterCopy);



        $sqlQuery->set($programsetting->dailyentrydate);
        $sqlQuery->set($programsetting->updatefiledate);

        $sqlQuery->setNumber($programsetting->workerbetweenstores);
        $sqlQuery->setNumber($programsetting->workshoptimeout);
        $sqlQuery->setNumber($programsetting->drivertimeout);
        $sqlQuery->set($programsetting->currancy);

        $sqlQuery->set($programsetting->serial);
        $id = $this->executeInsert($sqlQuery);
        $programsetting->programsettingsid = $id;

        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProgramsettingsMySql programsetting
     */
    public function update($programsetting) {
        $sql = 'UPDATE programsettings SET companyname = ?, address = ?, specializtion = ?, phone = ?, faxnumber = ?, email = ?, website = ?, logo = ?, roundnumbers = ?, saveprinting = ?, deptprinting = ?, printingpapersize = ?, userid = ?, showPreviousPrice = ?, parcode = ?, priceing = ?, lastprice = ?, searchvalue = ?, updateproductprice = ?, allowfinsldelete = ?, updateclientprice = ?, `partition` = ?, taxcard = ?, commercialregistration = ?, costcenter = ?, clinic = ?, workshop = ?, transport = ?, manufacturing = ?, masterCopy = ? , dailyentrydate = ? ,updatefiledate = ?,workerbetweenstores = ?,workshoptimeout = ?,drivertimeout = ?,currancy = ?,serial=? WHERE programsettingsid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($programsetting->companyname);
        $sqlQuery->set($programsetting->address);
        $sqlQuery->set($programsetting->specializtion);
        $sqlQuery->set($programsetting->phone);
        $sqlQuery->set($programsetting->faxnumber);
        $sqlQuery->set($programsetting->email);
        $sqlQuery->set($programsetting->website);
        $sqlQuery->set($programsetting->logo);
        $sqlQuery->setNumber($programsetting->roundnumbers);
        $sqlQuery->setNumber($programsetting->saveprinting);
        $sqlQuery->setNumber($programsetting->deptprinting);
        $sqlQuery->setNumber($programsetting->printingpapersize);
        $sqlQuery->setNumber($programsetting->userid);
        $sqlQuery->setNumber($programsetting->showPreviousPrice);
        $sqlQuery->setNumber($programsetting->parcode);
        $sqlQuery->setNumber($programsetting->priceing);
        $sqlQuery->setNumber($programsetting->lastprice);
        $sqlQuery->setNumber($programsetting->searchvalue);
        $sqlQuery->setNumber($programsetting->updateproductprice);
        $sqlQuery->setNumber($programsetting->allowfinsldelete);
        $sqlQuery->setNumber($programsetting->updateclientprice);
        $sqlQuery->set($programsetting->partition);
        $sqlQuery->set($programsetting->taxcard);
        $sqlQuery->set($programsetting->commercialregistration);
        $sqlQuery->setNumber($programsetting->costcenter);

        $sqlQuery->setNumber($programsetting->clinic);
        $sqlQuery->setNumber($programsetting->workshop);
        $sqlQuery->setNumber($programsetting->transport);
        $sqlQuery->setNumber($programsetting->manufacturing);
        $sqlQuery->setNumber($programsetting->masterCopy);


        $sqlQuery->set($programsetting->dailyentrydate);
        $sqlQuery->set($programsetting->updatefiledate);

        $sqlQuery->setNumber($programsetting->workerbetweenstores);
        $sqlQuery->setNumber($programsetting->workshoptimeout);
        $sqlQuery->setNumber($programsetting->drivertimeout);

        $sqlQuery->set($programsetting->currancy);
        $sqlQuery->set($programsetting->serial);

        $sqlQuery->setNumber($programsetting->programsettingsid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM programsettings';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByCompanyname($value) {
        $sql = 'SELECT * FROM programsettings WHERE companyname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAddress($value) {
        $sql = 'SELECT * FROM programsettings WHERE address = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySpecializtion($value) {
        $sql = 'SELECT * FROM programsettings WHERE specializtion = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPhone($value) {
        $sql = 'SELECT * FROM programsettings WHERE phone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByFaxnumber($value) {
        $sql = 'SELECT * FROM programsettings WHERE faxnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmail($value) {
        $sql = 'SELECT * FROM programsettings WHERE email = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWebsite($value) {
        $sql = 'SELECT * FROM programsettings WHERE website = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLogo($value) {
        $sql = 'SELECT * FROM programsettings WHERE logo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRoundnumbers($value) {
        $sql = 'SELECT * FROM programsettings WHERE roundnumbers = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveprinting($value) {
        $sql = 'SELECT * FROM programsettings WHERE saveprinting = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeptprinting($value) {
        $sql = 'SELECT * FROM programsettings WHERE deptprinting = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPrintingpapersize($value) {
        $sql = 'SELECT * FROM programsettings WHERE printingpapersize = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM programsettings WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByCompanyname($value) {
        $sql = 'DELETE FROM programsettings WHERE companyname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAddress($value) {
        $sql = 'DELETE FROM programsettings WHERE address = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySpecializtion($value) {
        $sql = 'DELETE FROM programsettings WHERE specializtion = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPhone($value) {
        $sql = 'DELETE FROM programsettings WHERE phone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByFaxnumber($value) {
        $sql = 'DELETE FROM programsettings WHERE faxnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmail($value) {
        $sql = 'DELETE FROM programsettings WHERE email = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWebsite($value) {
        $sql = 'DELETE FROM programsettings WHERE website = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLogo($value) {
        $sql = 'DELETE FROM programsettings WHERE logo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRoundnumbers($value) {
        $sql = 'DELETE FROM programsettings WHERE roundnumbers = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveprinting($value) {
        $sql = 'DELETE FROM programsettings WHERE saveprinting = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeptprinting($value) {
        $sql = 'DELETE FROM programsettings WHERE deptprinting = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPrintingpapersize($value) {
        $sql = 'DELETE FROM programsettings WHERE printingpapersize = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM programsettings WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProgramsettingsMySql
     */
    protected function readRow($row) {
        $programsetting = new Programsetting();

        $programsetting->programsettingsid = $row['programsettingsid'];
        $programsetting->companyname = $row['companyname'];
        $programsetting->address = $row['address'];
        $programsetting->specializtion = $row['specializtion'];
        $programsetting->phone = $row['phone'];
        $programsetting->faxnumber = $row['faxnumber'];
        $programsetting->email = $row['email'];
        $programsetting->website = $row['website'];
        $programsetting->logo = $row['logo'];
        $programsetting->roundnumbers = $row['roundnumbers'];
        $programsetting->saveprinting = $row['saveprinting'];
        $programsetting->deptprinting = $row['deptprinting'];
        $programsetting->printingpapersize = $row['printingpapersize'];
        $programsetting->userid = $row['userid'];
        $programsetting->showPreviousPrice = $row['showPreviousPrice'];
        $programsetting->parcode = $row['parcode'];
        $programsetting->priceing = $row['priceing'];
        $programsetting->lastprice = $row['lastprice'];
        $programsetting->searchvalue = $row['searchvalue'];
        $programsetting->updateproductprice = $row['updateproductprice'];

        $programsetting->allowfinsldelete = $row['allowfinsldelete'];
        $programsetting->updateclientprice = $row['updateclientprice'];
        $programsetting->partition = $row['partition'];
        $programsetting->taxcard = $row['taxcard'];
        $programsetting->commercialregistration = $row['commercialregistration'];
        $programsetting->costcenter = $row['costcenter'];

        $programsetting->clinic = $row['clinic'];
        $programsetting->workshop = $row['workshop'];
        $programsetting->transport = $row['transport'];
        $programsetting->manufacturing = $row['manufacturing'];
        $programsetting->masterCopy = $row['masterCopy'];
        $programsetting->dailyentrydate = $row['dailyentrydate'];
        $programsetting->updatefiledate = $row['updatefiledate'];

        $programsetting->workerbetweenstores = $row['workerbetweenstores'];
        $programsetting->workshoptimeout = $row['workshoptimeout'];
        $programsetting->drivertimeout = $row['drivertimeout'];
        $programsetting->currancy = $row['currancy'];
        $programsetting->serial = $row['serial'];


        return $programsetting;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProgramsettingsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>