<?php
/**
 * Class that operate on table 'notics'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-07-19 10:17
 */
class NoticsMySqlDAO implements NoticsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return NoticsMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM notics WHERE noticesid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM notics';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM notics ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param notic primary key
 	 */
	public function delete($noticesid){
		$sql = 'DELETE FROM notics WHERE noticesid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($noticesid);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param NoticsMySql notic
 	 */
	public function insert($notic){
		$sql = 'INSERT INTO notics (productno, productnotsellno, kempilano, clientcheckno, suppliercheckno) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($notic->productno);
		$sqlQuery->setNumber($notic->productnotsellno);
		$sqlQuery->setNumber($notic->kempilano);
		$sqlQuery->setNumber($notic->clientcheckno);
		$sqlQuery->setNumber($notic->suppliercheckno);

		$id = $this->executeInsert($sqlQuery);	
		$notic->noticesid = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param NoticsMySql notic
 	 */
	public function update($notic){
		$sql = 'UPDATE notics SET productno = ?, productnotsellno = ?, kempilano = ?, clientcheckno = ?, suppliercheckno = ? WHERE noticesid = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($notic->productno);
		$sqlQuery->setNumber($notic->productnotsellno);
		$sqlQuery->setNumber($notic->kempilano);
		$sqlQuery->setNumber($notic->clientcheckno);
		$sqlQuery->setNumber($notic->suppliercheckno);

		$sqlQuery->setNumber($notic->noticesid);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM notics';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByProductno($value){
		$sql = 'SELECT * FROM notics WHERE productno = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProductnotsellno($value){
		$sql = 'SELECT * FROM notics WHERE productnotsellno = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByKempilano($value){
		$sql = 'SELECT * FROM notics WHERE kempilano = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientcheckno($value){
		$sql = 'SELECT * FROM notics WHERE clientcheckno = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySuppliercheckno($value){
		$sql = 'SELECT * FROM notics WHERE suppliercheckno = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByProductno($value){
		$sql = 'DELETE FROM notics WHERE productno = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProductnotsellno($value){
		$sql = 'DELETE FROM notics WHERE productnotsellno = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByKempilano($value){
		$sql = 'DELETE FROM notics WHERE kempilano = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientcheckno($value){
		$sql = 'DELETE FROM notics WHERE clientcheckno = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySuppliercheckno($value){
		$sql = 'DELETE FROM notics WHERE suppliercheckno = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return NoticsMySql 
	 */
	protected function readRow($row){
		$notic = new Notic();
		
		$notic->noticesid = $row['noticesid'];
		$notic->productno = $row['productno'];
		$notic->productnotsellno = $row['productnotsellno'];
		$notic->kempilano = $row['kempilano'];
		$notic->clientcheckno = $row['clientcheckno'];
		$notic->suppliercheckno = $row['suppliercheckno'];

		return $notic;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return NoticsMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>