<?php
/**
 * Class that operate on table 'menuurl'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-10-22 14:58
 */
class MenuurlMySqlDAO implements MenuurlDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return MenuurlMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM menuurl WHERE menuurlid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM menuurl';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM menuurl ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param menuurl primary key
 	 */
	public function delete($menuurlid){
		$sql = 'DELETE FROM menuurl WHERE menuurlid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($menuurlid);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MenuurlMySql menuurl
 	 */
	public function insert($menuurl){
		$sql = 'INSERT INTO menuurl (urltitle, menuurl, urlimage, usergroupid) VALUES (?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($menuurl->urltitle);
		$sqlQuery->set($menuurl->menuurl);
		$sqlQuery->set($menuurl->urlimage);
		$sqlQuery->setString2($menuurl->usergroupid);

		$id = $this->executeInsert($sqlQuery);	
		$menuurl->menuurlid = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param MenuurlMySql menuurl
 	 */
	public function update($menuurl){
		$sql = 'UPDATE menuurl SET urltitle = ?, menuurl = ?, urlimage = ?, usergroupid = ? WHERE menuurlid = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($menuurl->urltitle);
		$sqlQuery->set($menuurl->menuurl);
		$sqlQuery->set($menuurl->urlimage);
		$sqlQuery->setString2($menuurl->usergroupid);

		$sqlQuery->setNumber($menuurl->menuurlid);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM menuurl';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUrltitle($value){
		$sql = 'SELECT * FROM menuurl WHERE urltitle = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMenuurl($value){
		$sql = 'SELECT * FROM menuurl WHERE menuurl = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUrlimage($value){
		$sql = 'SELECT * FROM menuurl WHERE urlimage = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUsergroupid($value){
		$sql = 'SELECT * FROM menuurl WHERE usergroupid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUrltitle($value){
		$sql = 'DELETE FROM menuurl WHERE urltitle = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMenuurl($value){
		$sql = 'DELETE FROM menuurl WHERE menuurl = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUrlimage($value){
		$sql = 'DELETE FROM menuurl WHERE urlimage = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUsergroupid($value){
		$sql = 'DELETE FROM menuurl WHERE usergroupid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return MenuurlMySql 
	 */
	protected function readRow($row){
		$menuurl = new Menuurl();
		
		$menuurl->menuurlid = $row['menuurlid'];
		$menuurl->urltitle = $row['urltitle'];
		$menuurl->menuurl = $row['menuurl'];
		$menuurl->urlimage = $row['urlimage'];
		$menuurl->usergroupid = $row['usergroupid'];

		return $menuurl;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return MenuurlMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>