<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-11-20 09:04
 */
interface SerialsarchiveDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Serialsarchive 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param serialsarchive primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Serialsarchive serialsarchive
 	 */
	public function insert($serialsarchive);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Serialsarchive serialsarchive
 	 */
	public function update($serialsarchive);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByDeviceid($value);

	public function queryByUserno($value);

	public function queryBySyncusers($value);

	public function queryByClientname($value);

	public function queryByDateto($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByConditions($value);


	public function deleteByDeviceid($value);

	public function deleteByUserno($value);

	public function deleteBySyncusers($value);

	public function deleteByClientname($value);

	public function deleteByDateto($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByConditions($value);


}
?>