<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface ProgramsettingsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Programsettings 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param programsetting primary key
 	 */
	public function delete($programsettingsid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Programsettings programsetting
 	 */
	public function insert($programsetting);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Programsettings programsetting
 	 */
	public function update($programsetting);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCompanyname($value);

	public function queryByAddress($value);

	public function queryBySpecializtion($value);

	public function queryByPhone($value);

	public function queryByFaxnumber($value);

	public function queryByEmail($value);

	public function queryByWebsite($value);

	public function queryByLogo($value);

	public function queryByRoundnumbers($value);

	public function queryBySaveprinting($value);

	public function queryByDeptprinting($value);

	public function queryByPrintingpapersize($value);

	public function queryByUserid($value);


	public function deleteByCompanyname($value);

	public function deleteByAddress($value);

	public function deleteBySpecializtion($value);

	public function deleteByPhone($value);

	public function deleteByFaxnumber($value);

	public function deleteByEmail($value);

	public function deleteByWebsite($value);

	public function deleteByLogo($value);

	public function deleteByRoundnumbers($value);

	public function deleteBySaveprinting($value);

	public function deleteByDeptprinting($value);

	public function deleteByPrintingpapersize($value);

	public function deleteByUserid($value);


}
?>